/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Comparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullOrdering {
    private static final Logger log = LoggerFactory.getLogger(PullOrdering.class);
    protected final PropertyDefinition rcttmProperty;
    protected final PropertyDefinition pullOrdering;
    protected final Superplan superplan;
    protected final Method method;

    protected PullOrdering(@Nonnull Superplan superplan, @Nonnull Method method) {
        this.superplan = Preconditions.checkNotNull(superplan, "superplan");
        this.method = Preconditions.checkNotNull(method, "method");
        this.rcttmProperty = superplan.getShopConf().getPropertyDefinition(GeneralizedOrderRequest.class, "rcttm");
        this.pullOrdering = superplan.getShopConf().getPropertyDefinition(GeneralizedOrderRequest.class, "pullOrdering");
        Preconditions.checkNotNull(this.pullOrdering, "Superplan must have the pullOrdering property for GORs.");
        if (this.rcttmProperty == null) {
            log.warn("Calculating pull ordering without having rcttm property defined on GORs.");
        }
    }

    public static void calculate(@Nonnull Superplan superplan, @Nonnull Method method) {
        new PullOrdering(superplan, method).calculate();
    }

    public static void calculate(@Nonnull Superplan superplan) {
        PullOrdering.calculate(superplan, Method.STRESS_FACTOR);
    }

    protected void calculate() {
        Preconditions.checkState(GeneralizedRequest.isDateValid(this.superplan.getFixationDate()), "Superplan must have its fixation date set.");
        long now = this.superplan.getFixationDate();
        ArrayList<GorWithScore> gors = Lists.newArrayListWithCapacity(this.superplan.getGors().size());
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            gors.add(new GorWithScore(gor, this.method.calculateScore(this, gor, now)));
        }
        Collections.sort(gors, new Comparator<GorWithScore>(){

            @Override
            public int compare(GorWithScore o1, GorWithScore o2) {
                int res = Comparators.compare(o1.gor.getPriority(), o2.gor.getPriority());
                if (res == 0 && (res = Comparators.compare(o1.score, o2.score)) == 0) {
                    res = o1.gor.getId().compareTo(o2.gor.getId());
                }
                return res;
            }
        });
        long pullOrder = 1L;
        for (GorWithScore gorWithSf : gors) {
            gorWithSf.gor.setProperty(this.pullOrdering, pullOrder);
            ++pullOrder;
        }
    }

    protected double calculateStressFactor(GeneralizedOrderRequest gor, long now) {
        Long rcttm = (Long)gor.getProperty(this.rcttmProperty);
        double res = rcttm != null && rcttm != 0L ? (double)(gor.getDueDate() - now) / (double)rcttm.longValue() : 1.0;
        return res;
    }

    protected double calculateLps(GeneralizedOrderRequest gor) {
        Long rcttm = (Long)gor.getProperty(this.rcttmProperty);
        long res = rcttm != null ? gor.getDueDate() - rcttm : gor.getDueDate();
        return res;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Method {
        STRESS_FACTOR{

            @Override
            double calculateScore(PullOrdering p, GeneralizedOrderRequest gor, long now) {
                return p.calculateStressFactor(gor, now);
            }
        }
        ,
        LPS{

            @Override
            double calculateScore(PullOrdering p, GeneralizedOrderRequest gor, long now) {
                return p.calculateLps(gor);
            }
        };


        abstract double calculateScore(PullOrdering var1, GeneralizedOrderRequest var2, long var3);
    }

    protected static class GorWithScore {
        public final GeneralizedOrderRequest gor;
        public final double score;

        private GorWithScore(GeneralizedOrderRequest gor, double score) {
            this.gor = gor;
            this.score = score;
        }
    }
}

